/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.constask;

import com.ibm.hwmca.base.constask.ConsoleTaskConstants;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Locale;

public class ConsoleTaskData
implements Serializable,
ConsoleTaskConstants {
    private boolean next;
    private String count;
    private ObjectId[] taskTargetIds;
    private String targetName;
    private String dateTime;
    private String taskName;
    private ObjectId taskId;
    private ArrayList targetStrings = new ArrayList();
    private PresentationTaskParms parms;
    private UserContext userContext;
    private static final String TRACE_MASKT = "XDRYDATT";
    private static final String TRACE_MASKF = "XDRYDATF";
    private static final String TRACE_MASKD = "XDRYDATD";

    public ConsoleTaskData() {
        Trace.trace(TRACE_MASKT, "<->ConsoleTaskData ()");
        this.userContext = UserContext.getCurrentUserContext();
        this.setDateTime();
    }

    public ConsoleTaskData(PresentationTaskParms parms) {
        Trace.trace(TRACE_MASKT, "->ConsoleTaskData (PresentationTaskParms parms)05/10/02");
        this.userContext = UserContext.getCurrentUserContext();
        this.parms = parms;
        this.taskTargetIds = parms.getTargetIds();
        this.taskId = parms.getTaskId();
        this.targetName = null;
        this.dateTime = null;
        this.taskName = null;
        this.setDateTime();
        this.setCount(1);
        this.buildTargetStringArray();
        this.buildTaskTargetsString();
        this.buildTaskNameString();
        Trace.trace(TRACE_MASKT, "<-ConsoleTaskData (PresentationTaskParms parms)");
    }

    public String getDateTime() {
        Trace.trace(TRACE_MASKD, "<->ConsoleTaskData getDateTime()- dateTime=" + this.dateTime);
        return this.dateTime;
    }

    public void setDateTime() {
        Trace.trace(TRACE_MASKD, "<->ConsoleTaskData setDateTime() ");
        this.dateTime = "";
        UserContext userContext = UserContext.getCurrentUserContext();
        GregorianCalendar time = new GregorianCalendar(userContext.getTimeZone(), userContext.getLocale());
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy' 'HH:mm:ss", userContext.getLocale());
        sdf.setTimeZone(userContext.getTimeZone());
        this.dateTime = sdf.format(time.getTime());
        Trace.trace(TRACE_MASKD, "dateTime=" + this.dateTime);
    }

    public void setNext(boolean booleanValue) {
        Trace.trace(TRACE_MASKD, "<->ConsoleTaskData setNext() ");
        this.next = booleanValue;
        Trace.trace(TRACE_MASKD, "<-ConsoleTaskData setNext()- next =" + this.next);
    }

    public boolean isNext() {
        Trace.trace(TRACE_MASKD, "<->ConsoleTaskData isNext() ");
        return this.next;
    }

    public void setCount(int intCount) {
        Trace.trace(TRACE_MASKD, "<->ConsoleTaskData setCount() ");
        this.count = Integer.toString(intCount);
        Trace.trace(TRACE_MASKD, "<-ConsoleTaskData setCount()-count=" + this.count);
    }

    public String getCount() {
        Trace.trace(TRACE_MASKD, "<->ConsoleTaskData getCount() - count =" + this.count);
        return this.count;
    }

    public void incrementCount() {
        Trace.trace(TRACE_MASKD, "<->ConsoleTaskData incrementCount() ");
        try {
            int intCount = Integer.parseInt(this.count);
            this.count = Integer.toString(++intCount);
        }
        catch (NumberFormatException nfe) {
            this.count = "?";
        }
        Trace.trace(TRACE_MASKD, "Count = " + this.count);
    }

    public void setTargetName(String targetName) {
        Trace.trace(TRACE_MASKD, "<->ConsoleTaskData setTargetName() ");
        this.targetName = targetName;
    }

    public String getTargetName() {
        Trace.trace(TRACE_MASKD, "<->ConsoleTaskData getTargetName() ");
        return this.targetName;
    }

    public void setTaskName(String taskName) {
        Trace.trace(TRACE_MASKD, "<->ConsoleTaskData setTaskName() ");
        this.taskName = taskName;
    }

    public String getTaskName() {
        Trace.trace(TRACE_MASKD, "<->ConsoleTaskData getTaskName() ");
        return this.taskName;
    }

    public void buildTargetStringArray() {
        Trace.trace(TRACE_MASKD, "->ConsoleTaskData buildTargetStringArray() ");
        if (this.taskTargetIds != null) {
            Trace.trace(TRACE_MASKD, "taskTargetIds size =" + this.taskTargetIds.length);
            int j = 0;
            for (int i = 0; i < this.taskTargetIds.length; ++i) {
                Trace.trace(TRACE_MASKD, "taskTargetIds[" + i + "]= " + this.taskTargetIds[i]);
                try {
                    ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
                    HwmcaObject targetObject = mom.get(this.taskTargetIds[i]);
                    if (targetObject == null) {
                        throw new IllegalArgumentException("ObjectId does not correspond to a target: " + this.taskTargetIds[i]);
                    }
                    String aTargetString = this.buildTargetString(targetObject);
                    this.targetStrings.add(j, aTargetString);
                    ++j;
                    Trace.trace(TRACE_MASKD, "targetStrings[" + i + "]=" + (String)this.targetStrings.get(i));
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    Trace.trace(TRACE_MASKF, "IllegalArgumentException ObbjectID for taskTargetIds[" + i + "]= " + this.taskTargetIds[i]);
                    Trace.trace(TRACE_MASKF, "ObjectID does not correspond to a target - adding null target array");
                }
            }
        } else {
            Trace.trace(TRACE_MASKD, "task has no targets");
        }
        Trace.trace(TRACE_MASKD, "<-ConsoleTaskData buildTargetStringArray() ");
    }

    private String buildTargetString(HwmcaObject targetObject) {
        Trace.trace(TRACE_MASKD, "-->buildTargetString(HwmcaObject)");
        LocalizableText targetNameText = targetObject.getUIInfo().getUnlocalizedName();
        String targetNameString = targetNameText.toString(this.userContext.getLocale());
        Trace.trace(TRACE_MASKD, "targetNameString after getLocale = " + targetNameString);
        targetNameString = targetNameString.replace('\n', ' ');
        Trace.trace(TRACE_MASKD, "targetNameString after replace = " + targetNameString);
        Trace.trace(TRACE_MASKD, "<--buildTargetString(HwmcaObject)");
        return targetNameString;
    }

    public void buildTaskTargetsString() {
        int buffIndex = 0;
        Trace.trace(TRACE_MASKD, "<->ConsoleTaskData buildTaskTargetsString() ");
        if (this.targetStrings != null && this.targetStrings.size() > 0 && this.taskTargetIds != null) {
            buffIndex = 0;
            StringBuffer targetBuff = new StringBuffer(29);
            String targetString = (String)this.targetStrings.get(0);
            targetBuff.insert(buffIndex, targetString);
            int sizeOfTarget = targetString.length();
            if (this.targetStrings.size() > 1) {
                targetBuff.append("+");
            }
            this.targetName = targetBuff.toString();
        } else {
            this.targetName = "";
        }
        Trace.trace(TRACE_MASKD, "targetName=" + this.targetName);
        Trace.trace(TRACE_MASKD, "<-ConsoleTaskData buildTaskTargetsString() ");
    }

    private void buildTaskNameString() {
        StringBuffer stringBuff = new StringBuffer();
        int buffIndex = 0;
        Trace.trace(TRACE_MASKD, "->ConsoleTaskData buildTaskNameString() ");
        ObjectId taskId = this.parms.getTaskId();
        String taskKeyNameString = (String)taskId.getKeyProperty("Name");
        ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
        HwmcaObject taskObject = mom.get(taskId);
        if (taskObject != null) {
            UIInfo uiInfo = taskObject.getUIInfo();
            String uneditedTaskUINameString = uiInfo.getTitle(Locale.getDefault()) + "(" + taskKeyNameString + ")";
            Trace.trace(TRACE_MASKD, "UneditedTaskUINameString = " + uneditedTaskUINameString);
            String taskUINameString = uneditedTaskUINameString.replace('\n', ' ');
            Trace.trace(TRACE_MASKD, "Edited taskUINameString = " + taskUINameString);
            stringBuff.insert(buffIndex, taskUINameString);
            Trace.trace(TRACE_MASKD, "After adding task names to stringBuff= " + stringBuff);
            if (!this.targetStrings.isEmpty()) {
                Trace.trace(TRACE_MASKD, "Add targets to stringBuff ");
                buffIndex = taskUINameString.length() + taskKeyNameString.length() + 2;
                Trace.trace(TRACE_MASKD, "buffIndex= " + buffIndex);
                stringBuff.append(" [");
                buffIndex += 2;
                Trace.trace(TRACE_MASKD, "Loop to add targets to stringBuff ");
                for (int i = 0; i < this.targetStrings.size(); ++i) {
                    Trace.trace(TRACE_MASKD, "index = " + i);
                    String targetWorkString = (String)this.targetStrings.get(i);
                    Trace.trace(TRACE_MASKD, "targetStrings array index[" + i + "]= " + targetWorkString);
                    stringBuff.append(targetWorkString);
                    Trace.trace(TRACE_MASKD, "Add string to buffer - buffindex= " + buffIndex);
                    Trace.trace(TRACE_MASKD, "Buffer looks like - " + stringBuff);
                    Trace.trace(TRACE_MASKD, "new buffindex= " + (buffIndex += targetWorkString.length()));
                    Trace.trace(TRACE_MASKD, "targetStrings size = " + this.targetStrings.size() + " i = " + i);
                    if (i == this.targetStrings.size() - 1) {
                        stringBuff.append("]");
                        ++buffIndex;
                    } else {
                        stringBuff.append(",");
                        ++buffIndex;
                    }
                    Trace.trace(TRACE_MASKD, "after adding target stringBuff = " + stringBuff);
                }
            }
        } else {
            throw new IllegalArgumentException("ObjectId does not correspond to a target: " + taskId);
        }
        this.taskName = stringBuff.toString();
        Trace.trace(TRACE_MASKD, "string taskName = " + this.taskName);
        Trace.trace(TRACE_MASKD, "<-ConsoleTaskData buildTaskNameString() ");
    }
}

